
using System.Collections.Generic;
using System;
using System.Linq;
using System.Drawing;
using System.Diagnostics;
using System.Data;
using System.Xml.Linq;
using Microsoft.VisualBasic;
using System.Collections;
using System.Windows.Forms;


using System.Net;
using System.Runtime.InteropServices;

namespace TCP_CLIENT
{
	public partial class Form1
	{
		public Form1()
		{
			InitializeComponent();
			
		    if (defaultInstance == null)
				defaultInstance = this;
		}
		
#region Default Instance
		
		private static Form1 defaultInstance;
		
		/// <summary>
		/// </summary>
public static Form1 Default
		{
			get
			{
				if (defaultInstance == null)
				{
					defaultInstance = new Form1();
					defaultInstance.FormClosed += new FormClosedEventHandler(defaultInstance_FormClosed);
				}
				
				return defaultInstance;
			}
			set
			{
				defaultInstance = value;
			}
		}
		
		static void defaultInstance_FormClosed(object sender, FormClosedEventArgs e)
		{
			defaultInstance = null;
		}
		
#endregion


        FinsTcp.PlcClient PLC = new FinsTcp.PlcClient();
		bool EntLink;
		long ScanCount;
		short ScanRet;
		bool ScanRun;
        IntPtr Handle;
		
		[DllImport("winmm.dll", ExactSpelling=true, CharSet=CharSet.Ansi, SetLastError=true)]
		public static extern UInt32 timeGetTime();
		
		public void Form1_Load(System.Object sender, System.EventArgs e)
		{
			short i = 0;
			this.CenterToScreen();
			cmbReadMry.Items.Clear();
			cmbReadMry.Items.Add("CIO");
			cmbReadMry.Items.Add("WR");
			cmbReadMry.Items.Add("DR");
			cmbReadMry.Items.Add("ER");
            cmbReadMry.Items.Add("TIM");
            cmbReadMry.Items.Add("CNT");
			cmbWriteMry.Items.Clear();
			cmbWriteMry.Items.Add("CIO");
			cmbWriteMry.Items.Add("WR");
			cmbWriteMry.Items.Add("DR");
			cmbWriteMry.Items.Add("ER");
            cmbWriteMry.Items.Add("TIM");
            cmbWriteMry.Items.Add("CNT");
			cmbBitMry.Items.Clear();
			cmbBitMry.Items.Add("CIO");
			cmbBitMry.Items.Add("WR");
			cmbBitMry.Items.Add("DR");
            cmbBitMry.Items.Add("ER");
			cmbReadType.Items.Clear();
			cmbReadType.Items.Add("INT16");
			cmbReadType.Items.Add("UINT16");
			cmbReadType.Items.Add("DINT32");
			cmbReadType.Items.Add("HEX32");
			cmbReadType.Items.Add("REAL32");
			cmbReadType.Items.Add("BIN16");
            cmbReadType.Items.Add("BCD16");
            cmbReadType.Items.Add("BCD32");
			cmbWriteType.Items.Clear();
			cmbWriteType.Items.Add("INT16");
			cmbWriteType.Items.Add("UINT16");
			cmbWriteType.Items.Add("DINT32");
			cmbWriteType.Items.Add("HEX32");
			cmbWriteType.Items.Add("REAL32");
			cmbWriteType.Items.Add("BIN16");
            cmbWriteType.Items.Add("BCD16");
            cmbWriteType.Items.Add("BCD32");
			for (i = 0; i <= 15; i++)
			{
				cmbBit.Items.Add("Bit" + System.Convert.ToString(i));
			}
			cmbReadMry.SelectedIndex = 2;
			cmbWriteMry.SelectedIndex = 2;
			cmbBitMry.SelectedIndex = 0;
			cmbBit.SelectedIndex = 0;
			cmbReadType.SelectedIndex = 0;
			cmbWriteType.SelectedIndex = 0;
			lstRead.Items.Clear();
			txtWrite.Text = "";
			
		}
		
		
		public void butLink_Click(System.Object sender, System.EventArgs e)
		{
			short re = 0;
			string restr = "";
            re = PLC.EntLink(txtLocalIP.Text.Trim(), Convert.ToUInt16(txtLocalPort.Text), txtRemoteIP.Text.Trim(), (Convert.ToUInt16(txtRemotePort.Text)),  "DEMO",ref Handle );
			txtReLink.Text = re.ToString();
			if (re == 0)
			{
				EntLink = true;
				MessageBox.Show("PLC联接成功!");
			}
			else
			{
				EntLink = false;
				MessageBox.Show("PLC联接失败: " + restr);
			}
		}
		
		public void butClose_Click(System.Object sender, System.EventArgs e)
		{
			short re = 0;
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			re = PLC.DeLink(Handle );
			txtReClose.Text = re.ToString();
		}
		
		public void butRead_Click(System.Object sender, System.EventArgs e)
		{
			short i = 0;
			object[] RD = null;
			RD = new object[Convert.ToUInt16(txtReadCnt.Text)];
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			int var1 = cmbReadType.SelectedIndex + 1;
            FinsTcp.PlcClient.DataType typ = (FinsTcp.PlcClient.DataType)var1;
			switch (cmbReadMry.SelectedIndex)
			{
				case 0:
                    ScanRet = PLC.CmdRead(Handle,FinsTcp.PlcClient.PlcMemory.CIO, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
					break;
				case 1:
                    ScanRet = PLC.CmdRead(Handle, FinsTcp.PlcClient.PlcMemory.WR, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
					break;
				case 2:
                    ScanRet = PLC.CmdRead(Handle, FinsTcp.PlcClient.PlcMemory.DR, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
					break;
				case 3:
                    ScanRet = PLC.CmdRead(Handle, FinsTcp.PlcClient.PlcMemory.ER, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
					break;
                case 4:
                    ScanRet = PLC.CmdRead(Handle, FinsTcp.PlcClient.PlcMemory.TIM, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
                    break;
                case 5:
                    ScanRet = PLC.CmdRead(Handle, FinsTcp.PlcClient.PlcMemory.CNT, typ, Convert.ToUInt16(txtReadAdd.Text), Convert.ToUInt16(txtReadCnt.Text), ref RD);
                    break;
			}
			txtReRead.Text = ScanRet.ToString();
			lstRead.Items.Clear();
			for (i = 0; i <= (RD.Length - 1); i++)
			{
				if (!(RD[i] == null))
				{
					lstRead.Items.Add(RD[i]);
				}
				else
				{
					lstRead.Items.Add("0");
				}
			}
			
		}
		
		
		public void butWrite_Click(System.Object sender, System.EventArgs e)
		{
			short i = 0;
			string[] temp = null;
			object[] WD = null;
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			WD = new object[Convert.ToUInt16(txtWriteCnt.Text)];
			temp = txtWrite.Text.Split('\n');
			for (i = 0; i <= (WD.Length - 1); i++)
			{
				if (i > (temp.Length - 1))
				{
					WD[i] = 0;
				}
				else
				{
					WD[i] = temp[i].Trim();
				}
			}
			int var1 = cmbWriteType.SelectedIndex + 1;
            FinsTcp.PlcClient.DataType typ = (FinsTcp.PlcClient.DataType)var1;
			switch (cmbWriteMry.SelectedIndex)
			{
				case 0:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.CIO, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
					break;
				case 1:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.WR, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
					break;
				case 2:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.DR, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
					break;
				case 3:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.ER, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
					break;
                case 4:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.TIM, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
                    break;
                case 5:
                    ScanRet = PLC.CmdWrite(Handle, FinsTcp.PlcClient.PlcMemory.CNT, typ, Convert.ToUInt16(txtWriteAdd.Text), Convert.ToUInt16(txtWriteCnt.Text), ref WD);
                    break;
			}
			txtReWrite.Text = ScanRet.ToString();
		}
		
		public void butScan_Click(System.Object sender, System.EventArgs e)
		{
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			if (butScan.Text == "Cycle R/W")
			{
				ScanCount = 0;
				ScanRun = true;
				Timer1.Enabled = true;
				butScan.Text = "Stop R/W";
			}
			else
			{
				ScanRun = false;
				Timer1.Enabled = false;
				butScan.Text = "Cycle R/W";
			}
		}
		
		public void Timer1_Tick(System.Object sender, System.EventArgs e)
		{
            Timer1.Enabled = false;
			if (!ScanRun)
			{
				butScan_Click(null, null);
				return;
			}
			int tim = System.Convert.ToInt32(timeGetTime());
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			//
			butRead_Click(null, null);
			if (ScanRet < 0)
			{
				ScanRun = false;
				return;
			}
			butWrite_Click(null, null);
			if (ScanRet < 0)
			{
				ScanRun = false;
				return;
			}
			//
			ScanCount++;
			txtScanCnt.Text = ScanCount.ToString();
			txtScanPrd.Text = (System.Convert.ToInt32(timeGetTime()) - tim).ToString() + "ms";
            Timer1.Enabled = true;
		}
		
		
		public void butBitTest_Click(System.Object sender, System.EventArgs e)
		{
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			bool rd = false;
			short re = 0;
			switch (cmbBitMry.SelectedIndex)
			{
				case 0:
                    re = PLC.Bit_Test(Handle, FinsTcp.PlcClient.PlcMemory.CIO, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex), ref rd);
					break;
				case 1:
                    re = PLC.Bit_Test(Handle, FinsTcp.PlcClient.PlcMemory.WR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex), ref rd);
					break;
				case 2:
                    re = PLC.Bit_Test(Handle, FinsTcp.PlcClient.PlcMemory.DR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex), ref rd);
					break;
                case 3:
                    re = PLC.Bit_Test(Handle, FinsTcp.PlcClient.PlcMemory.ER, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex), ref rd);
                    break;
			}
			txtBitTest.Text = rd.ToString();
			txtReBit.Text = re.ToString();
		}
		
		public void butBitSet_Click(System.Object sender, System.EventArgs e)
		{
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			short re = 0;
			switch (cmbBitMry.SelectedIndex)
			{
				case 0:
                    re = PLC.Bit_Set(Handle, FinsTcp.PlcClient.PlcMemory.CIO, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
				case 1:
                    re = PLC.Bit_Set(Handle, FinsTcp.PlcClient.PlcMemory.WR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
				case 2:
                    re = PLC.Bit_Set(Handle, FinsTcp.PlcClient.PlcMemory.DR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
                case 3:
                    re = PLC.Bit_Set(Handle, FinsTcp.PlcClient.PlcMemory.ER, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
                    break;
			}
			txtReBit.Text = re.ToString();
		}
		
		public void butBitRst_Click(System.Object sender, System.EventArgs e)
		{
			if (!EntLink)
			{
				MessageBox.Show("还未与PLC建立联接！");
				return;
			}
			short re = 0;
			switch (cmbBitMry.SelectedIndex)
			{
				case 0:
                    re = PLC.Bit_Reset(Handle, FinsTcp.PlcClient.PlcMemory.CIO, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
				case 1:
                    re = PLC.Bit_Reset(Handle, FinsTcp.PlcClient.PlcMemory.WR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
				case 2:
                    re = PLC.Bit_Reset(Handle, FinsTcp.PlcClient.PlcMemory.DR, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
					break;
                case 3:
                    re = PLC.Bit_Reset(Handle, FinsTcp.PlcClient.PlcMemory.ER, Convert.ToUInt16(txtBitAdd.Text), Convert.ToUInt16(cmbBit.SelectedIndex));
                    break;
			}
			txtReBit.Text = re.ToString();
		}
		
		
	}
	
}
